BM.Marker.addInitHook(function () {
    this.moveOptions = {
        origin: null,
        timer: null,
        done: 0,
        path: null,
        length: 0,
        replay: true,
        angle: 0
    };
    this.setSpeed = function (speed) {
        this.moveOptions.speed = isNaN(parseFloat(speed)) || parseFloat(speed) <= 0 ? 200 : parseFloat(speed);
    };
    this.getSpeed = function () {
        return this.moveOptions.speed;
    };
    this.moveAlong = function (path, speed, param) {
        path = path instanceof BM.Polyline ? path : new BM.Polyline(path);
        this.moveOptions.path = path;
        this.moveOptions.angle = param.angle ? param.angle : 0;
        this.moveOptions.replay = param.replay ?? true;
        this.moveOptions.autoRotate = param.autoRotate ?? true;
        this.moveOptions.length = BM.GeometryUtil.length(path);
        this.moveOptions.speed = isNaN(parseFloat(speed)) || parseFloat(speed <= 0) ? 200 : parseFloat(speed);
        this._move();
    };
    this.addPoint = function (Point) {
        if (Point instanceof BM.LatLng) {
            if (!this.moveOptions.path) throw ('未导入路径')
            this.pauseMove();
            this.moveOptions.path.addLatLng(Point);
            this.moveAlong(this.moveOptions.path, this.moveOptions.speed, {
                replay: this.moveOptions.replay
            });
        } else {
            throw ('这不是一个经纬对')
        }
    };
    this.addNew = function (Point) {
        if (Point instanceof BM.LatLng) {
            if (!this.moveOptions.path) throw ('未导入路径')
            this.pauseMove();
            this.moveOptions.done = 0;
            this.moveOptions.path.addLatLng(Point);
            let path = this.moveOptions.path.getLatLngs().slice(this.predecessor);
            if (path.length != 1) path.splice(0, 1, this.getLatLng());
            this.moveOptions.path.setLatLngs(path);
            this.moveAlong(this.moveOptions.path, this.moveOptions.speed, {
                replay: this.moveOptions.replay
            });
        } else {
            throw ('这不是一个经纬对')
        }
    };
    this.pauseMove = function () {
        clearInterval(this.moveOptions.timer);
        this.moveOptions.timer = null;
    };
    this.resumeMove = function () {
        if (!this.moveOptions.path) {
            throw ('未导入路径');
        }
        this._move();
    };
    this.stopMove = function () {
        this.pauseMove();
        this.moveOptions.done = 0;
    };
    this._move = function () {
        if (this.moveOptions.timer) return;
        let _t = this;
        this.moveOptions.timer = setInterval(function () {
            let done = _t.moveOptions.done;
            done += _t.moveOptions.speed / 1000 * 20;
            let radio = done / _t.moveOptions.length;
            if (_t.moveOptions.replay) {
                radio >= 1 ? (radio = 0, done = 0) : true;
            } else {
                if (radio >= 1) {
                    let p = BM.GeometryUtil.interpolateOnLine(_t._map, _t.moveOptions.path, true);
                    if (p) {
                        p.predecessor = _t.moveOptions.path.getLatLngs().length
                    } else {
                        _t.stopMove();
                        console.error('出错', _t.moveOptions.path)
                        return
                    };
                    let passed = _t.moveOptions.path.getLatLngs().slice(0, p.predecessor);
                    _t.fire('update_position', {
                        path: passed,
                        index: p.predecessor - 1
                    });
                    _t.stopMove();
                    return
                }
            }
            _t.moveOptions.done = done;
            let p = BM.GeometryUtil.interpolateOnLine(_t._map, _t.moveOptions.path, radio);
            _t.setLatLng(p.latLng);
            let pre_p = _t.moveOptions.path.getLatLngs()[p.predecessor];
            _t.predecessor = p.predecessor;
            if (pre_p) {
                let passed = _t.moveOptions.path.getLatLngs().slice(0, p.predecessor + 1);
                passed.push(p.latLng);
                let deg = BM.GeometryUtil.computeAngle(_t._map.project(pre_p), _t._map.project(p.latLng))
                _t.fire('update_position', {
                    path: passed,
                    index: p.predecessor,
                    deg: deg
                });
                // _t._icon.style.transformOrigin = '50% 50%';
                // _t._icon.style.transform += ' rotateZ(' + deg + 'deg)';
                if (_t.moveOptions.autoRotate) _t.setRotationAngle((deg + _t.moveOptions.angle) % 360);
            }
        }, 20);
    }
});
/*
初始化设置角度函数
*/
(function () {
    var proto_initIcon = BM.Marker.prototype._initIcon;
    var proto_setPos = BM.Marker.prototype._setPos;

    var oldIE = (BM.DomUtil.TRANSFORM === 'msTransform');

    BM.Marker.addInitHook(function () {
        var iconOptions = this.options.icon && this.options.icon.options;
        var iconAnchor = iconOptions && this.options.icon.options.iconAnchor;
        if (iconAnchor) {
            iconAnchor = (iconAnchor[0] + 'px ' + iconAnchor[1] + 'px');
        }
        this.options.rotationOrigin = this.options.rotationOrigin || iconAnchor || 'center bottom';
        this.options.rotationAngle = this.options.rotationAngle || 0;

        // Ensure marker keeps rotated during dragging
        this.on('drag', function (e) {
            e.target._applyRotation();
        });
    });

    BM.Marker.include({
        _initIcon: function () {
            proto_initIcon.call(this);
        },

        _setPos: function (pos) {
            proto_setPos.call(this, pos);
            this._applyRotation();
        },

        _applyRotation: function () {
            if (this.options.rotationAngle) {
                this._icon.style[BM.DomUtil.TRANSFORM + 'Origin'] = this.options.rotationOrigin;

                if (oldIE) {
                    // for IE 9, use the 2D rotation
                    this._icon.style[BM.DomUtil.TRANSFORM] = 'rotate(' + this.options.rotationAngle + 'deg)';
                } else {
                    // for modern browsers, prefer the 3D accelerated version
                    this._icon.style[BM.DomUtil.TRANSFORM] += ' rotateZ(' + this.options.rotationAngle + 'deg)';
                }
            }
        },

        setRotationAngle: function (angle) {
            this.options.rotationAngle = angle;
            this.update();
            return this;
        },

        setRotationOrigin: function (origin) {
            this.options.rotationOrigin = origin;
            this.update();
            return this;
        }
    });
})();